%------------------------------------------------------------------------------
% File     : ITP097^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Liouville_Numbers problem prob_81__5865280_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Liouville_Numbers/prob_81__5865280_1 [Des21]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.30 v8.2.0, 0.15 v8.1.0, 0.18 v7.5.0
% Syntax   : Number of formulae    :  396 ( 279 unt;  42 typ;   0 def)
%            Number of atoms       :  778 ( 477 equ;   0 cnn)
%            Maximal formula atoms :    8 (   2 avg)
%            Number of connectives : 1870 (  48   ~;  14   |;  13   &;1664   @)
%                                         (   0 <=>; 131  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   4 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   67 (  67   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   40 (  37 usr;  11 con; 0-3 aty)
%            Number of variables   :  590 (  12   ^; 564   !;  14   ?; 590   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:39:12.418
%------------------------------------------------------------------------------
% Could-be-implicit typings (5)
thf(ty_n_t__Set__Oset_It__Real__Oreal_J,type,
    set_real: $tType ).

thf(ty_n_t__Real__Oreal,type,
    real: $tType ).

thf(ty_n_t__Num__Onum,type,
    num: $tType ).

thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

thf(ty_n_t__Int__Oint,type,
    int: $tType ).

% Explicit typings (37)
thf(sy_c_Archimedean__Field_Oceiling_001t__Real__Oreal,type,
    archim1371465213g_real: real > int ).

thf(sy_c_Groups_Oone__class_Oone_001t__Int__Oint,type,
    one_one_int: int ).

thf(sy_c_Groups_Oone__class_Oone_001t__Nat__Onat,type,
    one_one_nat: nat ).

thf(sy_c_Groups_Oone__class_Oone_001t__Real__Oreal,type,
    one_one_real: real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Int__Oint,type,
    zero_zero_int: int ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Nat__Onat,type,
    zero_zero_nat: nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Real__Oreal,type,
    zero_zero_real: real ).

thf(sy_c_If_001t__Nat__Onat,type,
    if_nat: $o > nat > nat > nat ).

thf(sy_c_Int_Onat,type,
    nat2: int > nat ).

thf(sy_c_Int_Oring__1__class_Oof__int_001t__Int__Oint,type,
    ring_1_of_int_int: int > int ).

thf(sy_c_Int_Oring__1__class_Oof__int_001t__Real__Oreal,type,
    ring_1_of_int_real: int > real ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_001t__Int__Oint,type,
    semiri2019852685at_int: nat > int ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_001t__Nat__Onat,type,
    semiri1382578993at_nat: nat > nat ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat_001t__Real__Oreal,type,
    semiri2110766477t_real: nat > real ).

thf(sy_c_Num_Oneg__numeral__class_Odbl_001t__Int__Oint,type,
    neg_numeral_dbl_int: int > int ).

thf(sy_c_Num_Oneg__numeral__class_Odbl_001t__Real__Oreal,type,
    neg_numeral_dbl_real: real > real ).

thf(sy_c_Num_Onum_OBit0,type,
    bit0: num > num ).

thf(sy_c_Num_Onum_OOne,type,
    one: num ).

thf(sy_c_Num_Onumeral__class_Onumeral_001t__Int__Oint,type,
    numeral_numeral_int: num > int ).

thf(sy_c_Num_Onumeral__class_Onumeral_001t__Nat__Onat,type,
    numeral_numeral_nat: num > nat ).

thf(sy_c_Num_Onumeral__class_Onumeral_001t__Real__Oreal,type,
    numeral_numeral_real: num > real ).

thf(sy_c_Num_Opow,type,
    pow: num > num > num ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Int__Oint,type,
    ord_less_int: int > int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Int__Oint,type,
    ord_less_eq_int: int > int > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Nat__Onat,type,
    ord_less_eq_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Num__Onum,type,
    ord_less_eq_num: num > num > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Real__Oreal,type,
    ord_less_eq_real: real > real > $o ).

thf(sy_c_Power_Opower__class_Opower_001t__Int__Oint,type,
    power_power_int: int > nat > int ).

thf(sy_c_Power_Opower__class_Opower_001t__Nat__Onat,type,
    power_power_nat: nat > nat > nat ).

thf(sy_c_Power_Opower__class_Opower_001t__Real__Oreal,type,
    power_power_real: real > nat > real ).

thf(sy_c_Set_OCollect_001t__Real__Oreal,type,
    collect_real: ( real > $o ) > set_real ).

thf(sy_c_Transcendental_Olog,type,
    log: real > real > real ).

thf(sy_c_Transcendental_Opowr_001t__Real__Oreal,type,
    powr_real: real > real > real ).

thf(sy_c_member_001t__Real__Oreal,type,
    member_real: real > set_real > $o ).

thf(sy_v_d____,type,
    d: int ).

thf(sy_v_n____,type,
    n: nat ).

% Relevant facts (350)
thf(fact_0_numeral__power__le__of__int__cancel__iff,axiom,
    ! [X: num,N: nat,A: int] :
      ( ( ord_less_eq_int @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) @ ( ring_1_of_int_int @ A ) )
      = ( ord_less_eq_int @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) @ A ) ) ).

% numeral_power_le_of_int_cancel_iff
thf(fact_1_numeral__power__le__of__int__cancel__iff,axiom,
    ! [X: num,N: nat,A: int] :
      ( ( ord_less_eq_real @ ( power_power_real @ ( numeral_numeral_real @ X ) @ N ) @ ( ring_1_of_int_real @ A ) )
      = ( ord_less_eq_int @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) @ A ) ) ).

% numeral_power_le_of_int_cancel_iff
thf(fact_2_of__int__le__numeral__power__cancel__iff,axiom,
    ! [A: int,X: num,N: nat] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ A ) @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) )
      = ( ord_less_eq_int @ A @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% of_int_le_numeral_power_cancel_iff
thf(fact_3_of__int__le__numeral__power__cancel__iff,axiom,
    ! [A: int,X: num,N: nat] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ A ) @ ( power_power_real @ ( numeral_numeral_real @ X ) @ N ) )
      = ( ord_less_eq_int @ A @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% of_int_le_numeral_power_cancel_iff
thf(fact_4_ceiling__numeral__power,axiom,
    ! [X: num,N: nat] :
      ( ( archim1371465213g_real @ ( power_power_real @ ( numeral_numeral_real @ X ) @ N ) )
      = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ).

% ceiling_numeral_power
thf(fact_5_numeral__power__eq__of__int__cancel__iff,axiom,
    ! [X: num,N: nat,Y: int] :
      ( ( ( power_power_int @ ( numeral_numeral_int @ X ) @ N )
        = ( ring_1_of_int_int @ Y ) )
      = ( ( power_power_int @ ( numeral_numeral_int @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_of_int_cancel_iff
thf(fact_6_numeral__power__eq__of__int__cancel__iff,axiom,
    ! [X: num,N: nat,Y: int] :
      ( ( ( power_power_real @ ( numeral_numeral_real @ X ) @ N )
        = ( ring_1_of_int_real @ Y ) )
      = ( ( power_power_int @ ( numeral_numeral_int @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_of_int_cancel_iff
thf(fact_7_of__int__eq__numeral__power__cancel__iff,axiom,
    ! [Y: int,X: num,N: nat] :
      ( ( ( ring_1_of_int_int @ Y )
        = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) )
      = ( Y
        = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% of_int_eq_numeral_power_cancel_iff
thf(fact_8_of__int__eq__numeral__power__cancel__iff,axiom,
    ! [Y: int,X: num,N: nat] :
      ( ( ( ring_1_of_int_real @ Y )
        = ( power_power_real @ ( numeral_numeral_real @ X ) @ N ) )
      = ( Y
        = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% of_int_eq_numeral_power_cancel_iff
thf(fact_9_of__int__le__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ord_less_eq_int @ ( power_power_int @ ( ring_1_of_int_int @ B ) @ W ) @ ( ring_1_of_int_int @ X ) )
      = ( ord_less_eq_int @ ( power_power_int @ B @ W ) @ X ) ) ).

% of_int_le_of_int_power_cancel_iff
thf(fact_10_of__int__le__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ord_less_eq_real @ ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) @ ( ring_1_of_int_real @ X ) )
      = ( ord_less_eq_int @ ( power_power_int @ B @ W ) @ X ) ) ).

% of_int_le_of_int_power_cancel_iff
thf(fact_11_of__int__power__le__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ X ) @ ( power_power_int @ ( ring_1_of_int_int @ B ) @ W ) )
      = ( ord_less_eq_int @ X @ ( power_power_int @ B @ W ) ) ) ).

% of_int_power_le_of_int_cancel_iff
thf(fact_12_of__int__power__le__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ X ) @ ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) )
      = ( ord_less_eq_int @ X @ ( power_power_int @ B @ W ) ) ) ).

% of_int_power_le_of_int_cancel_iff
thf(fact_13_ceiling__le__numeral,axiom,
    ! [X: real,V: num] :
      ( ( ord_less_eq_int @ ( archim1371465213g_real @ X ) @ ( numeral_numeral_int @ V ) )
      = ( ord_less_eq_real @ X @ ( numeral_numeral_real @ V ) ) ) ).

% ceiling_le_numeral
thf(fact_14_of__int__le__numeral__iff,axiom,
    ! [Z: int,N: num] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ Z ) @ ( numeral_numeral_int @ N ) )
      = ( ord_less_eq_int @ Z @ ( numeral_numeral_int @ N ) ) ) ).

% of_int_le_numeral_iff
thf(fact_15_of__int__le__numeral__iff,axiom,
    ! [Z: int,N: num] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ Z ) @ ( numeral_numeral_real @ N ) )
      = ( ord_less_eq_int @ Z @ ( numeral_numeral_int @ N ) ) ) ).

% of_int_le_numeral_iff
thf(fact_16_of__int__numeral__le__iff,axiom,
    ! [N: num,Z: int] :
      ( ( ord_less_eq_int @ ( numeral_numeral_int @ N ) @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_eq_int @ ( numeral_numeral_int @ N ) @ Z ) ) ).

% of_int_numeral_le_iff
thf(fact_17_of__int__numeral__le__iff,axiom,
    ! [N: num,Z: int] :
      ( ( ord_less_eq_real @ ( numeral_numeral_real @ N ) @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_eq_int @ ( numeral_numeral_int @ N ) @ Z ) ) ).

% of_int_numeral_le_iff
thf(fact_18_of__int__power,axiom,
    ! [Z: int,N: nat] :
      ( ( ring_1_of_int_int @ ( power_power_int @ Z @ N ) )
      = ( power_power_int @ ( ring_1_of_int_int @ Z ) @ N ) ) ).

% of_int_power
thf(fact_19_of__int__power,axiom,
    ! [Z: int,N: nat] :
      ( ( ring_1_of_int_real @ ( power_power_int @ Z @ N ) )
      = ( power_power_real @ ( ring_1_of_int_real @ Z ) @ N ) ) ).

% of_int_power
thf(fact_20_of__int__eq__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ( power_power_int @ ( ring_1_of_int_int @ B ) @ W )
        = ( ring_1_of_int_int @ X ) )
      = ( ( power_power_int @ B @ W )
        = X ) ) ).

% of_int_eq_of_int_power_cancel_iff
thf(fact_21_of__int__eq__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ( power_power_real @ ( ring_1_of_int_real @ B ) @ W )
        = ( ring_1_of_int_real @ X ) )
      = ( ( power_power_int @ B @ W )
        = X ) ) ).

% of_int_eq_of_int_power_cancel_iff
thf(fact_22_of__int__eq__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ( ring_1_of_int_real @ W )
        = ( ring_1_of_int_real @ Z ) )
      = ( W = Z ) ) ).

% of_int_eq_iff
thf(fact_23_of__int__eq__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ( ring_1_of_int_int @ W )
        = ( ring_1_of_int_int @ Z ) )
      = ( W = Z ) ) ).

% of_int_eq_iff
thf(fact_24_nat__numeral,axiom,
    ! [K: num] :
      ( ( nat2 @ ( numeral_numeral_int @ K ) )
      = ( numeral_numeral_nat @ K ) ) ).

% nat_numeral
thf(fact_25_ceiling__of__int,axiom,
    ! [Z: int] :
      ( ( archim1371465213g_real @ ( ring_1_of_int_real @ Z ) )
      = Z ) ).

% ceiling_of_int
thf(fact_26_of__int__ceiling__cancel,axiom,
    ! [X: real] :
      ( ( ( ring_1_of_int_real @ ( archim1371465213g_real @ X ) )
        = X )
      = ( ? [N2: int] :
            ( X
            = ( ring_1_of_int_real @ N2 ) ) ) ) ).

% of_int_ceiling_cancel
thf(fact_27_of__int__le__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ W ) @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_eq_int @ W @ Z ) ) ).

% of_int_le_iff
thf(fact_28_of__int__le__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ W ) @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_eq_int @ W @ Z ) ) ).

% of_int_le_iff
thf(fact_29_of__int__numeral,axiom,
    ! [K: num] :
      ( ( ring_1_of_int_int @ ( numeral_numeral_int @ K ) )
      = ( numeral_numeral_int @ K ) ) ).

% of_int_numeral
thf(fact_30_of__int__numeral,axiom,
    ! [K: num] :
      ( ( ring_1_of_int_real @ ( numeral_numeral_int @ K ) )
      = ( numeral_numeral_real @ K ) ) ).

% of_int_numeral
thf(fact_31_of__int__eq__numeral__iff,axiom,
    ! [Z: int,N: num] :
      ( ( ( ring_1_of_int_int @ Z )
        = ( numeral_numeral_int @ N ) )
      = ( Z
        = ( numeral_numeral_int @ N ) ) ) ).

% of_int_eq_numeral_iff
thf(fact_32_of__int__eq__numeral__iff,axiom,
    ! [Z: int,N: num] :
      ( ( ( ring_1_of_int_real @ Z )
        = ( numeral_numeral_real @ N ) )
      = ( Z
        = ( numeral_numeral_int @ N ) ) ) ).

% of_int_eq_numeral_iff
thf(fact_33_ceiling__numeral,axiom,
    ! [V: num] :
      ( ( archim1371465213g_real @ ( numeral_numeral_real @ V ) )
      = ( numeral_numeral_int @ V ) ) ).

% ceiling_numeral
thf(fact_34_of__int__power__eq__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ( ring_1_of_int_int @ X )
        = ( power_power_int @ ( ring_1_of_int_int @ B ) @ W ) )
      = ( X
        = ( power_power_int @ B @ W ) ) ) ).

% of_int_power_eq_of_int_cancel_iff
thf(fact_35_of__int__power__eq__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ( ring_1_of_int_real @ X )
        = ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) )
      = ( X
        = ( power_power_int @ B @ W ) ) ) ).

% of_int_power_eq_of_int_cancel_iff
thf(fact_36_numeral__power__eq__nat__cancel__iff,axiom,
    ! [X: num,N: nat,Y: int] :
      ( ( ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N )
        = ( nat2 @ Y ) )
      = ( ( power_power_int @ ( numeral_numeral_int @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_nat_cancel_iff
thf(fact_37_nat__eq__numeral__power__cancel__iff,axiom,
    ! [Y: int,X: num,N: nat] :
      ( ( ( nat2 @ Y )
        = ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) )
      = ( Y
        = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% nat_eq_numeral_power_cancel_iff
thf(fact_38_numeral__power__le__nat__cancel__iff,axiom,
    ! [X: num,N: nat,A: int] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) @ ( nat2 @ A ) )
      = ( ord_less_eq_int @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) @ A ) ) ).

% numeral_power_le_nat_cancel_iff
thf(fact_39_nat__le__numeral__power__cancel__iff,axiom,
    ! [A: int,X: num,N: nat] :
      ( ( ord_less_eq_nat @ ( nat2 @ A ) @ ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) )
      = ( ord_less_eq_int @ A @ ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) ) ) ).

% nat_le_numeral_power_cancel_iff
thf(fact_40_nat__mono,axiom,
    ! [X: int,Y: int] :
      ( ( ord_less_eq_int @ X @ Y )
     => ( ord_less_eq_nat @ ( nat2 @ X ) @ ( nat2 @ Y ) ) ) ).

% nat_mono
thf(fact_41_ex__le__of__int,axiom,
    ! [X: real] :
    ? [Z2: int] : ( ord_less_eq_real @ X @ ( ring_1_of_int_real @ Z2 ) ) ).

% ex_le_of_int
thf(fact_42_le__of__int__ceiling,axiom,
    ! [X: real] : ( ord_less_eq_real @ X @ ( ring_1_of_int_real @ ( archim1371465213g_real @ X ) ) ) ).

% le_of_int_ceiling
thf(fact_43_ceiling__mono,axiom,
    ! [Y: real,X: real] :
      ( ( ord_less_eq_real @ Y @ X )
     => ( ord_less_eq_int @ ( archim1371465213g_real @ Y ) @ ( archim1371465213g_real @ X ) ) ) ).

% ceiling_mono
thf(fact_44_ceiling__le__iff,axiom,
    ! [X: real,Z: int] :
      ( ( ord_less_eq_int @ ( archim1371465213g_real @ X ) @ Z )
      = ( ord_less_eq_real @ X @ ( ring_1_of_int_real @ Z ) ) ) ).

% ceiling_le_iff
thf(fact_45_ceiling__le,axiom,
    ! [X: real,A: int] :
      ( ( ord_less_eq_real @ X @ ( ring_1_of_int_real @ A ) )
     => ( ord_less_eq_int @ ( archim1371465213g_real @ X ) @ A ) ) ).

% ceiling_le
thf(fact_46__092_060open_062log_A2_A1_A_092_060le_062_Alog_A2_A_Ireal__of__int_Ad_J_092_060close_062,axiom,
    ord_less_eq_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ one_one_real ) @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ).

% \<open>log 2 1 \<le> log 2 (real_of_int d)\<close>
thf(fact_47_semiring__norm_I69_J,axiom,
    ! [M: num] :
      ~ ( ord_less_eq_num @ ( bit0 @ M ) @ one ) ).

% semiring_norm(69)
thf(fact_48_semiring__norm_I83_J,axiom,
    ! [N: num] :
      ( one
     != ( bit0 @ N ) ) ).

% semiring_norm(83)
thf(fact_49_semiring__norm_I85_J,axiom,
    ! [M: num] :
      ( ( bit0 @ M )
     != one ) ).

% semiring_norm(85)
thf(fact_50_numeral__le__iff,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq_int @ ( numeral_numeral_int @ M ) @ ( numeral_numeral_int @ N ) )
      = ( ord_less_eq_num @ M @ N ) ) ).

% numeral_le_iff
thf(fact_51_numeral__le__iff,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq_nat @ ( numeral_numeral_nat @ M ) @ ( numeral_numeral_nat @ N ) )
      = ( ord_less_eq_num @ M @ N ) ) ).

% numeral_le_iff
thf(fact_52_numeral__le__iff,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq_real @ ( numeral_numeral_real @ M ) @ ( numeral_numeral_real @ N ) )
      = ( ord_less_eq_num @ M @ N ) ) ).

% numeral_le_iff
thf(fact_53__092_060open_062real__of__int_Ad_A_061_A2_Apowr_Alog_A2_A_Ireal__of__int_Ad_J_092_060close_062,axiom,
    ( ( ring_1_of_int_real @ d )
    = ( powr_real @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ).

% \<open>real_of_int d = 2 powr log 2 (real_of_int d)\<close>
thf(fact_54_n__def,axiom,
    ( n
    = ( suc @ ( nat2 @ ( archim1371465213g_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ) ) ).

% n_def
thf(fact_55_semiring__norm_I68_J,axiom,
    ! [N: num] : ( ord_less_eq_num @ one @ N ) ).

% semiring_norm(68)
thf(fact_56_semiring__norm_I71_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq_num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( ord_less_eq_num @ M @ N ) ) ).

% semiring_norm(71)
thf(fact_57_semiring__norm_I87_J,axiom,
    ! [M: num,N: num] :
      ( ( ( bit0 @ M )
        = ( bit0 @ N ) )
      = ( M = N ) ) ).

% semiring_norm(87)
thf(fact_58_verit__eq__simplify_I8_J,axiom,
    ! [X2: num,Y2: num] :
      ( ( ( bit0 @ X2 )
        = ( bit0 @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% verit_eq_simplify(8)
thf(fact_59_numeral__eq__iff,axiom,
    ! [M: num,N: num] :
      ( ( ( numeral_numeral_int @ M )
        = ( numeral_numeral_int @ N ) )
      = ( M = N ) ) ).

% numeral_eq_iff
thf(fact_60_numeral__eq__iff,axiom,
    ! [M: num,N: num] :
      ( ( ( numeral_numeral_real @ M )
        = ( numeral_numeral_real @ N ) )
      = ( M = N ) ) ).

% numeral_eq_iff
thf(fact_61_numeral__eq__iff,axiom,
    ! [M: num,N: num] :
      ( ( ( numeral_numeral_nat @ M )
        = ( numeral_numeral_nat @ N ) )
      = ( M = N ) ) ).

% numeral_eq_iff
thf(fact_62_of__int__eq__1__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_real @ Z )
        = one_one_real )
      = ( Z = one_one_int ) ) ).

% of_int_eq_1_iff
thf(fact_63_of__int__eq__1__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_int @ Z )
        = one_one_int )
      = ( Z = one_one_int ) ) ).

% of_int_eq_1_iff
thf(fact_64_mem__Collect__eq,axiom,
    ! [A: real,P: real > $o] :
      ( ( member_real @ A @ ( collect_real @ P ) )
      = ( P @ A ) ) ).

% mem_Collect_eq
thf(fact_65_Collect__mem__eq,axiom,
    ! [A2: set_real] :
      ( ( collect_real
        @ ^ [X3: real] : ( member_real @ X3 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_66_of__int__1,axiom,
    ( ( ring_1_of_int_real @ one_one_int )
    = one_one_real ) ).

% of_int_1
thf(fact_67_of__int__1,axiom,
    ( ( ring_1_of_int_int @ one_one_int )
    = one_one_int ) ).

% of_int_1
thf(fact_68_ceiling__one,axiom,
    ( ( archim1371465213g_real @ one_one_real )
    = one_one_int ) ).

% ceiling_one
thf(fact_69_numeral__eq__one__iff,axiom,
    ! [N: num] :
      ( ( ( numeral_numeral_int @ N )
        = one_one_int )
      = ( N = one ) ) ).

% numeral_eq_one_iff
thf(fact_70_numeral__eq__one__iff,axiom,
    ! [N: num] :
      ( ( ( numeral_numeral_real @ N )
        = one_one_real )
      = ( N = one ) ) ).

% numeral_eq_one_iff
thf(fact_71_numeral__eq__one__iff,axiom,
    ! [N: num] :
      ( ( ( numeral_numeral_nat @ N )
        = one_one_nat )
      = ( N = one ) ) ).

% numeral_eq_one_iff
thf(fact_72_one__eq__numeral__iff,axiom,
    ! [N: num] :
      ( ( one_one_int
        = ( numeral_numeral_int @ N ) )
      = ( one = N ) ) ).

% one_eq_numeral_iff
thf(fact_73_one__eq__numeral__iff,axiom,
    ! [N: num] :
      ( ( one_one_real
        = ( numeral_numeral_real @ N ) )
      = ( one = N ) ) ).

% one_eq_numeral_iff
thf(fact_74_one__eq__numeral__iff,axiom,
    ! [N: num] :
      ( ( one_one_nat
        = ( numeral_numeral_nat @ N ) )
      = ( one = N ) ) ).

% one_eq_numeral_iff
thf(fact_75_of__int__1__le__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ one_one_int @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_eq_int @ one_one_int @ Z ) ) ).

% of_int_1_le_iff
thf(fact_76_of__int__1__le__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_real @ one_one_real @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_eq_int @ one_one_int @ Z ) ) ).

% of_int_1_le_iff
thf(fact_77_of__int__le__1__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ Z ) @ one_one_int )
      = ( ord_less_eq_int @ Z @ one_one_int ) ) ).

% of_int_le_1_iff
thf(fact_78_of__int__le__1__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ Z ) @ one_one_real )
      = ( ord_less_eq_int @ Z @ one_one_int ) ) ).

% of_int_le_1_iff
thf(fact_79_ceiling__le__one,axiom,
    ! [X: real] :
      ( ( ord_less_eq_int @ ( archim1371465213g_real @ X ) @ one_one_int )
      = ( ord_less_eq_real @ X @ one_one_real ) ) ).

% ceiling_le_one
thf(fact_80_numeral__le__one__iff,axiom,
    ! [N: num] :
      ( ( ord_less_eq_int @ ( numeral_numeral_int @ N ) @ one_one_int )
      = ( ord_less_eq_num @ N @ one ) ) ).

% numeral_le_one_iff
thf(fact_81_numeral__le__one__iff,axiom,
    ! [N: num] :
      ( ( ord_less_eq_nat @ ( numeral_numeral_nat @ N ) @ one_one_nat )
      = ( ord_less_eq_num @ N @ one ) ) ).

% numeral_le_one_iff
thf(fact_82_numeral__le__one__iff,axiom,
    ! [N: num] :
      ( ( ord_less_eq_real @ ( numeral_numeral_real @ N ) @ one_one_real )
      = ( ord_less_eq_num @ N @ one ) ) ).

% numeral_le_one_iff
thf(fact_83_complete__real,axiom,
    ! [S: set_real] :
      ( ? [X4: real] : ( member_real @ X4 @ S )
     => ( ? [Z3: real] :
          ! [X5: real] :
            ( ( member_real @ X5 @ S )
           => ( ord_less_eq_real @ X5 @ Z3 ) )
       => ? [Y3: real] :
            ( ! [X4: real] :
                ( ( member_real @ X4 @ S )
               => ( ord_less_eq_real @ X4 @ Y3 ) )
            & ! [Z3: real] :
                ( ! [X5: real] :
                    ( ( member_real @ X5 @ S )
                   => ( ord_less_eq_real @ X5 @ Z3 ) )
               => ( ord_less_eq_real @ Y3 @ Z3 ) ) ) ) ) ).

% complete_real
thf(fact_84_le__numeral__extra_I4_J,axiom,
    ord_less_eq_int @ one_one_int @ one_one_int ).

% le_numeral_extra(4)
thf(fact_85_le__numeral__extra_I4_J,axiom,
    ord_less_eq_nat @ one_one_nat @ one_one_nat ).

% le_numeral_extra(4)
thf(fact_86_le__numeral__extra_I4_J,axiom,
    ord_less_eq_real @ one_one_real @ one_one_real ).

% le_numeral_extra(4)
thf(fact_87_one__le__numeral,axiom,
    ! [N: num] : ( ord_less_eq_int @ one_one_int @ ( numeral_numeral_int @ N ) ) ).

% one_le_numeral
thf(fact_88_one__le__numeral,axiom,
    ! [N: num] : ( ord_less_eq_nat @ one_one_nat @ ( numeral_numeral_nat @ N ) ) ).

% one_le_numeral
thf(fact_89_one__le__numeral,axiom,
    ! [N: num] : ( ord_less_eq_real @ one_one_real @ ( numeral_numeral_real @ N ) ) ).

% one_le_numeral
thf(fact_90_numeral__One,axiom,
    ( ( numeral_numeral_int @ one )
    = one_one_int ) ).

% numeral_One
thf(fact_91_numeral__One,axiom,
    ( ( numeral_numeral_real @ one )
    = one_one_real ) ).

% numeral_One
thf(fact_92_numeral__One,axiom,
    ( ( numeral_numeral_nat @ one )
    = one_one_nat ) ).

% numeral_One
thf(fact_93_verit__la__disequality,axiom,
    ! [A: int,B: int] :
      ( ( A = B )
      | ~ ( ord_less_eq_int @ A @ B )
      | ~ ( ord_less_eq_int @ B @ A ) ) ).

% verit_la_disequality
thf(fact_94_verit__la__disequality,axiom,
    ! [A: nat,B: nat] :
      ( ( A = B )
      | ~ ( ord_less_eq_nat @ A @ B )
      | ~ ( ord_less_eq_nat @ B @ A ) ) ).

% verit_la_disequality
thf(fact_95_verit__la__disequality,axiom,
    ! [A: real,B: real] :
      ( ( A = B )
      | ~ ( ord_less_eq_real @ A @ B )
      | ~ ( ord_less_eq_real @ B @ A ) ) ).

% verit_la_disequality
thf(fact_96_verit__la__disequality,axiom,
    ! [A: num,B: num] :
      ( ( A = B )
      | ~ ( ord_less_eq_num @ A @ B )
      | ~ ( ord_less_eq_num @ B @ A ) ) ).

% verit_la_disequality
thf(fact_97_le__num__One__iff,axiom,
    ! [X: num] :
      ( ( ord_less_eq_num @ X @ one )
      = ( X = one ) ) ).

% le_num_One_iff
thf(fact_98_two__realpow__ge__one,axiom,
    ! [N: nat] : ( ord_less_eq_real @ one_one_real @ ( power_power_real @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ N ) ) ).

% two_realpow_ge_one
thf(fact_99_verit__la__generic,axiom,
    ! [A: int,X: int] :
      ( ( ord_less_eq_int @ A @ X )
      | ( A = X )
      | ( ord_less_eq_int @ X @ A ) ) ).

% verit_la_generic
thf(fact_100_verit__eq__simplify_I10_J,axiom,
    ! [X2: num] :
      ( one
     != ( bit0 @ X2 ) ) ).

% verit_eq_simplify(10)
thf(fact_101_nat__numeral__as__int,axiom,
    ( numeral_numeral_nat
    = ( ^ [I: num] : ( nat2 @ ( numeral_numeral_int @ I ) ) ) ) ).

% nat_numeral_as_int
thf(fact_102__092_060open_0622_Apowr_Areal_A_Inat_A_092_060lceil_062log_A2_A_Ireal__of__int_Ad_J_092_060rceil_062_J_A_061_Areal__of__int_A_I2_A_094_Anat_A_092_060lceil_062log_A2_A_Ireal__of__int_Ad_J_092_060rceil_062_J_092_060close_062,axiom,
    ( ( powr_real @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( semiri2110766477t_real @ ( nat2 @ ( archim1371465213g_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ) )
    = ( ring_1_of_int_real @ ( power_power_int @ ( numeral_numeral_int @ ( bit0 @ one ) ) @ ( nat2 @ ( archim1371465213g_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ) ) ) ).

% \<open>2 powr real (nat \<lceil>log 2 (real_of_int d)\<rceil>) = real_of_int (2 ^ nat \<lceil>log 2 (real_of_int d)\<rceil>)\<close>
thf(fact_103__092_060open_0622_Apowr_Alog_A2_A_Ireal__of__int_Ad_J_A_092_060le_062_A2_Apowr_Areal_A_Inat_A_092_060lceil_062log_A2_A_Ireal__of__int_Ad_J_092_060rceil_062_J_092_060close_062,axiom,
    ord_less_eq_real @ ( powr_real @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) @ ( powr_real @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( semiri2110766477t_real @ ( nat2 @ ( archim1371465213g_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ) ) ).

% \<open>2 powr log 2 (real_of_int d) \<le> 2 powr real (nat \<lceil>log 2 (real_of_int d)\<rceil>)\<close>
thf(fact_104_numeral__powr__numeral__real,axiom,
    ! [M: num,N: num] :
      ( ( powr_real @ ( numeral_numeral_real @ M ) @ ( numeral_numeral_real @ N ) )
      = ( power_power_real @ ( numeral_numeral_real @ M ) @ ( numeral_numeral_nat @ N ) ) ) ).

% numeral_powr_numeral_real
thf(fact_105_powr__one__eq__one,axiom,
    ! [A: real] :
      ( ( powr_real @ one_one_real @ A )
      = one_one_real ) ).

% powr_one_eq_one
thf(fact_106_self__le__ge2__pow,axiom,
    ! [K: nat,M: nat] :
      ( ( ord_less_eq_nat @ ( numeral_numeral_nat @ ( bit0 @ one ) ) @ K )
     => ( ord_less_eq_nat @ M @ ( power_power_nat @ K @ M ) ) ) ).

% self_le_ge2_pow
thf(fact_107_power2__nat__le__eq__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ M @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) @ ( power_power_nat @ N @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% power2_nat_le_eq_le
thf(fact_108_power2__nat__le__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ M @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% power2_nat_le_imp_le
thf(fact_109_Suc__le__mono,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq_nat @ ( suc @ N ) @ ( suc @ M ) )
      = ( ord_less_eq_nat @ N @ M ) ) ).

% Suc_le_mono
thf(fact_110_power__one__right,axiom,
    ! [A: int] :
      ( ( power_power_int @ A @ one_one_nat )
      = A ) ).

% power_one_right
thf(fact_111_power__one__right,axiom,
    ! [A: nat] :
      ( ( power_power_nat @ A @ one_one_nat )
      = A ) ).

% power_one_right
thf(fact_112_power__one__right,axiom,
    ! [A: real] :
      ( ( power_power_real @ A @ one_one_nat )
      = A ) ).

% power_one_right
thf(fact_113_nat_Oinject,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ( suc @ X2 )
        = ( suc @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% nat.inject
thf(fact_114_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_115_of__nat__eq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( semiri2110766477t_real @ M )
        = ( semiri2110766477t_real @ N ) )
      = ( M = N ) ) ).

% of_nat_eq_iff
thf(fact_116_of__nat__eq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( semiri2019852685at_int @ M )
        = ( semiri2019852685at_int @ N ) )
      = ( M = N ) ) ).

% of_nat_eq_iff
thf(fact_117_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_int @ one_one_int @ N )
      = one_one_int ) ).

% power_one
thf(fact_118_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_nat @ one_one_nat @ N )
      = one_one_nat ) ).

% power_one
thf(fact_119_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_real @ one_one_real @ N )
      = one_one_real ) ).

% power_one
thf(fact_120_of__nat__eq__1__iff,axiom,
    ! [N: nat] :
      ( ( ( semiri1382578993at_nat @ N )
        = one_one_nat )
      = ( N = one_one_nat ) ) ).

% of_nat_eq_1_iff
thf(fact_121_of__nat__eq__1__iff,axiom,
    ! [N: nat] :
      ( ( ( semiri2110766477t_real @ N )
        = one_one_real )
      = ( N = one_one_nat ) ) ).

% of_nat_eq_1_iff
thf(fact_122_of__nat__eq__1__iff,axiom,
    ! [N: nat] :
      ( ( ( semiri2019852685at_int @ N )
        = one_one_int )
      = ( N = one_one_nat ) ) ).

% of_nat_eq_1_iff
thf(fact_123_of__nat__1__eq__iff,axiom,
    ! [N: nat] :
      ( ( one_one_nat
        = ( semiri1382578993at_nat @ N ) )
      = ( N = one_one_nat ) ) ).

% of_nat_1_eq_iff
thf(fact_124_of__nat__1__eq__iff,axiom,
    ! [N: nat] :
      ( ( one_one_real
        = ( semiri2110766477t_real @ N ) )
      = ( N = one_one_nat ) ) ).

% of_nat_1_eq_iff
thf(fact_125_of__nat__1__eq__iff,axiom,
    ! [N: nat] :
      ( ( one_one_int
        = ( semiri2019852685at_int @ N ) )
      = ( N = one_one_nat ) ) ).

% of_nat_1_eq_iff
thf(fact_126_of__nat__1,axiom,
    ( ( semiri1382578993at_nat @ one_one_nat )
    = one_one_nat ) ).

% of_nat_1
thf(fact_127_of__nat__1,axiom,
    ( ( semiri2110766477t_real @ one_one_nat )
    = one_one_real ) ).

% of_nat_1
thf(fact_128_of__nat__1,axiom,
    ( ( semiri2019852685at_int @ one_one_nat )
    = one_one_int ) ).

% of_nat_1
thf(fact_129_of__int__of__nat__eq,axiom,
    ! [N: nat] :
      ( ( ring_1_of_int_real @ ( semiri2019852685at_int @ N ) )
      = ( semiri2110766477t_real @ N ) ) ).

% of_int_of_nat_eq
thf(fact_130_of__int__of__nat__eq,axiom,
    ! [N: nat] :
      ( ( ring_1_of_int_int @ ( semiri2019852685at_int @ N ) )
      = ( semiri2019852685at_int @ N ) ) ).

% of_int_of_nat_eq
thf(fact_131_ceiling__of__nat,axiom,
    ! [N: nat] :
      ( ( archim1371465213g_real @ ( semiri2110766477t_real @ N ) )
      = ( semiri2019852685at_int @ N ) ) ).

% ceiling_of_nat
thf(fact_132_of__nat__le__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_int @ ( semiri2019852685at_int @ M ) @ ( semiri2019852685at_int @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% of_nat_le_iff
thf(fact_133_of__nat__le__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( semiri1382578993at_nat @ M ) @ ( semiri1382578993at_nat @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% of_nat_le_iff
thf(fact_134_of__nat__le__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_real @ ( semiri2110766477t_real @ M ) @ ( semiri2110766477t_real @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% of_nat_le_iff
thf(fact_135_of__nat__numeral,axiom,
    ! [N: num] :
      ( ( semiri1382578993at_nat @ ( numeral_numeral_nat @ N ) )
      = ( numeral_numeral_nat @ N ) ) ).

% of_nat_numeral
thf(fact_136_of__nat__numeral,axiom,
    ! [N: num] :
      ( ( semiri2110766477t_real @ ( numeral_numeral_nat @ N ) )
      = ( numeral_numeral_real @ N ) ) ).

% of_nat_numeral
thf(fact_137_of__nat__numeral,axiom,
    ! [N: num] :
      ( ( semiri2019852685at_int @ ( numeral_numeral_nat @ N ) )
      = ( numeral_numeral_int @ N ) ) ).

% of_nat_numeral
thf(fact_138_of__nat__power__eq__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ( semiri1382578993at_nat @ X )
        = ( power_power_nat @ ( semiri1382578993at_nat @ B ) @ W ) )
      = ( X
        = ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_eq_of_nat_cancel_iff
thf(fact_139_of__nat__power__eq__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ( semiri2110766477t_real @ X )
        = ( power_power_real @ ( semiri2110766477t_real @ B ) @ W ) )
      = ( X
        = ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_eq_of_nat_cancel_iff
thf(fact_140_of__nat__power__eq__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ( semiri2019852685at_int @ X )
        = ( power_power_int @ ( semiri2019852685at_int @ B ) @ W ) )
      = ( X
        = ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_eq_of_nat_cancel_iff
thf(fact_141_of__nat__eq__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ( power_power_nat @ ( semiri1382578993at_nat @ B ) @ W )
        = ( semiri1382578993at_nat @ X ) )
      = ( ( power_power_nat @ B @ W )
        = X ) ) ).

% of_nat_eq_of_nat_power_cancel_iff
thf(fact_142_of__nat__eq__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ( power_power_real @ ( semiri2110766477t_real @ B ) @ W )
        = ( semiri2110766477t_real @ X ) )
      = ( ( power_power_nat @ B @ W )
        = X ) ) ).

% of_nat_eq_of_nat_power_cancel_iff
thf(fact_143_of__nat__eq__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ( power_power_int @ ( semiri2019852685at_int @ B ) @ W )
        = ( semiri2019852685at_int @ X ) )
      = ( ( power_power_nat @ B @ W )
        = X ) ) ).

% of_nat_eq_of_nat_power_cancel_iff
thf(fact_144_of__nat__power,axiom,
    ! [M: nat,N: nat] :
      ( ( semiri1382578993at_nat @ ( power_power_nat @ M @ N ) )
      = ( power_power_nat @ ( semiri1382578993at_nat @ M ) @ N ) ) ).

% of_nat_power
thf(fact_145_of__nat__power,axiom,
    ! [M: nat,N: nat] :
      ( ( semiri2110766477t_real @ ( power_power_nat @ M @ N ) )
      = ( power_power_real @ ( semiri2110766477t_real @ M ) @ N ) ) ).

% of_nat_power
thf(fact_146_of__nat__power,axiom,
    ! [M: nat,N: nat] :
      ( ( semiri2019852685at_int @ ( power_power_nat @ M @ N ) )
      = ( power_power_int @ ( semiri2019852685at_int @ M ) @ N ) ) ).

% of_nat_power
thf(fact_147_Suc__1,axiom,
    ( ( suc @ one_one_nat )
    = ( numeral_numeral_nat @ ( bit0 @ one ) ) ) ).

% Suc_1
thf(fact_148_of__nat__power__le__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ord_less_eq_int @ ( semiri2019852685at_int @ X ) @ ( power_power_int @ ( semiri2019852685at_int @ B ) @ W ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_le_of_nat_cancel_iff
thf(fact_149_of__nat__power__le__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ord_less_eq_nat @ ( semiri1382578993at_nat @ X ) @ ( power_power_nat @ ( semiri1382578993at_nat @ B ) @ W ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_le_of_nat_cancel_iff
thf(fact_150_of__nat__power__le__of__nat__cancel__iff,axiom,
    ! [X: nat,B: nat,W: nat] :
      ( ( ord_less_eq_real @ ( semiri2110766477t_real @ X ) @ ( power_power_real @ ( semiri2110766477t_real @ B ) @ W ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ B @ W ) ) ) ).

% of_nat_power_le_of_nat_cancel_iff
thf(fact_151_of__nat__le__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ord_less_eq_int @ ( power_power_int @ ( semiri2019852685at_int @ B ) @ W ) @ ( semiri2019852685at_int @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ B @ W ) @ X ) ) ).

% of_nat_le_of_nat_power_cancel_iff
thf(fact_152_of__nat__le__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ ( semiri1382578993at_nat @ B ) @ W ) @ ( semiri1382578993at_nat @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ B @ W ) @ X ) ) ).

% of_nat_le_of_nat_power_cancel_iff
thf(fact_153_of__nat__le__of__nat__power__cancel__iff,axiom,
    ! [B: nat,W: nat,X: nat] :
      ( ( ord_less_eq_real @ ( power_power_real @ ( semiri2110766477t_real @ B ) @ W ) @ ( semiri2110766477t_real @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ B @ W ) @ X ) ) ).

% of_nat_le_of_nat_power_cancel_iff
thf(fact_154_real__of__nat__eq__numeral__power__cancel__iff,axiom,
    ! [Y: nat,X: num,N: nat] :
      ( ( ( semiri1382578993at_nat @ Y )
        = ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) )
      = ( Y
        = ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) ) ) ).

% real_of_nat_eq_numeral_power_cancel_iff
thf(fact_155_real__of__nat__eq__numeral__power__cancel__iff,axiom,
    ! [Y: nat,X: num,N: nat] :
      ( ( ( semiri2110766477t_real @ Y )
        = ( power_power_real @ ( numeral_numeral_real @ X ) @ N ) )
      = ( Y
        = ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) ) ) ).

% real_of_nat_eq_numeral_power_cancel_iff
thf(fact_156_real__of__nat__eq__numeral__power__cancel__iff,axiom,
    ! [Y: nat,X: num,N: nat] :
      ( ( ( semiri2019852685at_int @ Y )
        = ( power_power_int @ ( numeral_numeral_int @ X ) @ N ) )
      = ( Y
        = ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N ) ) ) ).

% real_of_nat_eq_numeral_power_cancel_iff
thf(fact_157_numeral__power__eq__of__nat__cancel__iff,axiom,
    ! [X: num,N: nat,Y: nat] :
      ( ( ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N )
        = ( semiri1382578993at_nat @ Y ) )
      = ( ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_of_nat_cancel_iff
thf(fact_158_numeral__power__eq__of__nat__cancel__iff,axiom,
    ! [X: num,N: nat,Y: nat] :
      ( ( ( power_power_real @ ( numeral_numeral_real @ X ) @ N )
        = ( semiri2110766477t_real @ Y ) )
      = ( ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_of_nat_cancel_iff
thf(fact_159_numeral__power__eq__of__nat__cancel__iff,axiom,
    ! [X: num,N: nat,Y: nat] :
      ( ( ( power_power_int @ ( numeral_numeral_int @ X ) @ N )
        = ( semiri2019852685at_int @ Y ) )
      = ( ( power_power_nat @ ( numeral_numeral_nat @ X ) @ N )
        = Y ) ) ).

% numeral_power_eq_of_nat_cancel_iff
thf(fact_160_numeral__le__real__of__nat__iff,axiom,
    ! [N: num,M: nat] :
      ( ( ord_less_eq_real @ ( numeral_numeral_real @ N ) @ ( semiri2110766477t_real @ M ) )
      = ( ord_less_eq_nat @ ( numeral_numeral_nat @ N ) @ M ) ) ).

% numeral_le_real_of_nat_iff
thf(fact_161_nat__ceiling__le__eq,axiom,
    ! [X: real,A: nat] :
      ( ( ord_less_eq_nat @ ( nat2 @ ( archim1371465213g_real @ X ) ) @ A )
      = ( ord_less_eq_real @ X @ ( semiri2110766477t_real @ A ) ) ) ).

% nat_ceiling_le_eq
thf(fact_162_of__nat__le__numeral__power__cancel__iff,axiom,
    ! [X: nat,I2: num,N: nat] :
      ( ( ord_less_eq_int @ ( semiri2019852685at_int @ X ) @ ( power_power_int @ ( numeral_numeral_int @ I2 ) @ N ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) ) ) ).

% of_nat_le_numeral_power_cancel_iff
thf(fact_163_of__nat__le__numeral__power__cancel__iff,axiom,
    ! [X: nat,I2: num,N: nat] :
      ( ( ord_less_eq_nat @ ( semiri1382578993at_nat @ X ) @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) ) ) ).

% of_nat_le_numeral_power_cancel_iff
thf(fact_164_of__nat__le__numeral__power__cancel__iff,axiom,
    ! [X: nat,I2: num,N: nat] :
      ( ( ord_less_eq_real @ ( semiri2110766477t_real @ X ) @ ( power_power_real @ ( numeral_numeral_real @ I2 ) @ N ) )
      = ( ord_less_eq_nat @ X @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) ) ) ).

% of_nat_le_numeral_power_cancel_iff
thf(fact_165_numeral__power__le__of__nat__cancel__iff,axiom,
    ! [I2: num,N: nat,X: nat] :
      ( ( ord_less_eq_int @ ( power_power_int @ ( numeral_numeral_int @ I2 ) @ N ) @ ( semiri2019852685at_int @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) @ X ) ) ).

% numeral_power_le_of_nat_cancel_iff
thf(fact_166_numeral__power__le__of__nat__cancel__iff,axiom,
    ! [I2: num,N: nat,X: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) @ ( semiri1382578993at_nat @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) @ X ) ) ).

% numeral_power_le_of_nat_cancel_iff
thf(fact_167_numeral__power__le__of__nat__cancel__iff,axiom,
    ! [I2: num,N: nat,X: nat] :
      ( ( ord_less_eq_real @ ( power_power_real @ ( numeral_numeral_real @ I2 ) @ N ) @ ( semiri2110766477t_real @ X ) )
      = ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ I2 ) @ N ) @ X ) ) ).

% numeral_power_le_of_nat_cancel_iff
thf(fact_168_nat__one__as__int,axiom,
    ( one_one_nat
    = ( nat2 @ one_one_int ) ) ).

% nat_one_as_int
thf(fact_169_real__arch__simple,axiom,
    ! [X: real] :
    ? [N3: nat] : ( ord_less_eq_real @ X @ ( semiri2110766477t_real @ N3 ) ) ).

% real_arch_simple
thf(fact_170_of__nat__mono,axiom,
    ! [I2: nat,J: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_int @ ( semiri2019852685at_int @ I2 ) @ ( semiri2019852685at_int @ J ) ) ) ).

% of_nat_mono
thf(fact_171_of__nat__mono,axiom,
    ! [I2: nat,J: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_nat @ ( semiri1382578993at_nat @ I2 ) @ ( semiri1382578993at_nat @ J ) ) ) ).

% of_nat_mono
thf(fact_172_of__nat__mono,axiom,
    ! [I2: nat,J: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_real @ ( semiri2110766477t_real @ I2 ) @ ( semiri2110766477t_real @ J ) ) ) ).

% of_nat_mono
thf(fact_173_numerals_I1_J,axiom,
    ( ( numeral_numeral_nat @ one )
    = one_one_nat ) ).

% numerals(1)
thf(fact_174_of__nat__ceiling,axiom,
    ! [R: real] : ( ord_less_eq_real @ R @ ( semiri2110766477t_real @ ( nat2 @ ( archim1371465213g_real @ R ) ) ) ) ).

% of_nat_ceiling
thf(fact_175_Suc__inject,axiom,
    ! [X: nat,Y: nat] :
      ( ( ( suc @ X )
        = ( suc @ Y ) )
     => ( X = Y ) ) ).

% Suc_inject
thf(fact_176_n__not__Suc__n,axiom,
    ! [N: nat] :
      ( N
     != ( suc @ N ) ) ).

% n_not_Suc_n
thf(fact_177_Nat_Oex__has__greatest__nat,axiom,
    ! [P: nat > $o,K: nat,B: nat] :
      ( ( P @ K )
     => ( ! [Y3: nat] :
            ( ( P @ Y3 )
           => ( ord_less_eq_nat @ Y3 @ B ) )
       => ? [X5: nat] :
            ( ( P @ X5 )
            & ! [Y4: nat] :
                ( ( P @ Y4 )
               => ( ord_less_eq_nat @ Y4 @ X5 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_178_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_179_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_180_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_181_le__trans,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ord_less_eq_nat @ I2 @ K ) ) ) ).

% le_trans
thf(fact_182_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ N @ N ) ).

% le_refl
thf(fact_183_real__nat__ceiling__ge,axiom,
    ! [X: real] : ( ord_less_eq_real @ X @ ( semiri2110766477t_real @ ( nat2 @ ( archim1371465213g_real @ X ) ) ) ) ).

% real_nat_ceiling_ge
thf(fact_184_powr__powr__swap,axiom,
    ! [X: real,A: real,B: real] :
      ( ( powr_real @ ( powr_real @ X @ A ) @ B )
      = ( powr_real @ ( powr_real @ X @ B ) @ A ) ) ).

% powr_powr_swap
thf(fact_185_log2__of__power__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( M
        = ( power_power_nat @ ( numeral_numeral_nat @ ( bit0 @ one ) ) @ N ) )
     => ( ( semiri2110766477t_real @ N )
        = ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( semiri2110766477t_real @ M ) ) ) ) ).

% log2_of_power_eq
thf(fact_186_le__log2__of__power,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_eq_nat @ ( power_power_nat @ ( numeral_numeral_nat @ ( bit0 @ one ) ) @ N ) @ M )
     => ( ord_less_eq_real @ ( semiri2110766477t_real @ N ) @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( semiri2110766477t_real @ M ) ) ) ) ).

% le_log2_of_power
thf(fact_187_transitive__stepwise__le,axiom,
    ! [M: nat,N: nat,R2: nat > nat > $o] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ! [X5: nat] : ( R2 @ X5 @ X5 )
       => ( ! [X5: nat,Y3: nat,Z2: nat] :
              ( ( R2 @ X5 @ Y3 )
             => ( ( R2 @ Y3 @ Z2 )
               => ( R2 @ X5 @ Z2 ) ) )
         => ( ! [N3: nat] : ( R2 @ N3 @ ( suc @ N3 ) )
           => ( R2 @ M @ N ) ) ) ) ) ).

% transitive_stepwise_le
thf(fact_188_nat__induct__at__least,axiom,
    ! [M: nat,N: nat,P: nat > $o] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( P @ M )
       => ( ! [N3: nat] :
              ( ( ord_less_eq_nat @ M @ N3 )
             => ( ( P @ N3 )
               => ( P @ ( suc @ N3 ) ) ) )
         => ( P @ N ) ) ) ) ).

% nat_induct_at_least
thf(fact_189_full__nat__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M2: nat] :
              ( ( ord_less_eq_nat @ ( suc @ M2 ) @ N3 )
             => ( P @ M2 ) )
         => ( P @ N3 ) )
     => ( P @ N ) ) ).

% full_nat_induct
thf(fact_190_not__less__eq__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less_eq_nat @ M @ N ) )
      = ( ord_less_eq_nat @ ( suc @ N ) @ M ) ) ).

% not_less_eq_eq
thf(fact_191_Suc__n__not__le__n,axiom,
    ! [N: nat] :
      ~ ( ord_less_eq_nat @ ( suc @ N ) @ N ) ).

% Suc_n_not_le_n
thf(fact_192_le__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ ( suc @ N ) )
      = ( ( ord_less_eq_nat @ M @ N )
        | ( M
          = ( suc @ N ) ) ) ) ).

% le_Suc_eq
thf(fact_193_Suc__le__D,axiom,
    ! [N: nat,M3: nat] :
      ( ( ord_less_eq_nat @ ( suc @ N ) @ M3 )
     => ? [M4: nat] :
          ( M3
          = ( suc @ M4 ) ) ) ).

% Suc_le_D
thf(fact_194_le__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ ( suc @ N ) ) ) ).

% le_SucI
thf(fact_195_le__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less_eq_nat @ M @ N )
       => ( M
          = ( suc @ N ) ) ) ) ).

% le_SucE
thf(fact_196_Suc__leD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( suc @ M ) @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% Suc_leD
thf(fact_197_one__le__power,axiom,
    ! [A: int,N: nat] :
      ( ( ord_less_eq_int @ one_one_int @ A )
     => ( ord_less_eq_int @ one_one_int @ ( power_power_int @ A @ N ) ) ) ).

% one_le_power
thf(fact_198_one__le__power,axiom,
    ! [A: nat,N: nat] :
      ( ( ord_less_eq_nat @ one_one_nat @ A )
     => ( ord_less_eq_nat @ one_one_nat @ ( power_power_nat @ A @ N ) ) ) ).

% one_le_power
thf(fact_199_one__le__power,axiom,
    ! [A: real,N: nat] :
      ( ( ord_less_eq_real @ one_one_real @ A )
     => ( ord_less_eq_real @ one_one_real @ ( power_power_real @ A @ N ) ) ) ).

% one_le_power
thf(fact_200_lift__Suc__antimono__le,axiom,
    ! [F: nat > int,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_int @ ( F @ ( suc @ N3 ) ) @ ( F @ N3 ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_int @ ( F @ N4 ) @ ( F @ N ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_201_lift__Suc__antimono__le,axiom,
    ! [F: nat > nat,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_nat @ ( F @ ( suc @ N3 ) ) @ ( F @ N3 ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_nat @ ( F @ N4 ) @ ( F @ N ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_202_lift__Suc__antimono__le,axiom,
    ! [F: nat > real,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_real @ ( F @ ( suc @ N3 ) ) @ ( F @ N3 ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_real @ ( F @ N4 ) @ ( F @ N ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_203_lift__Suc__antimono__le,axiom,
    ! [F: nat > num,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_num @ ( F @ ( suc @ N3 ) ) @ ( F @ N3 ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_num @ ( F @ N4 ) @ ( F @ N ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_204_lift__Suc__mono__le,axiom,
    ! [F: nat > int,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_int @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_int @ ( F @ N ) @ ( F @ N4 ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_205_lift__Suc__mono__le,axiom,
    ! [F: nat > nat,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_nat @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_nat @ ( F @ N ) @ ( F @ N4 ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_206_lift__Suc__mono__le,axiom,
    ! [F: nat > real,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_real @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_real @ ( F @ N ) @ ( F @ N4 ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_207_lift__Suc__mono__le,axiom,
    ! [F: nat > num,N: nat,N4: nat] :
      ( ! [N3: nat] : ( ord_less_eq_num @ ( F @ N3 ) @ ( F @ ( suc @ N3 ) ) )
     => ( ( ord_less_eq_nat @ N @ N4 )
       => ( ord_less_eq_num @ ( F @ N ) @ ( F @ N4 ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_208_powr__mono,axiom,
    ! [A: real,B: real,X: real] :
      ( ( ord_less_eq_real @ A @ B )
     => ( ( ord_less_eq_real @ one_one_real @ X )
       => ( ord_less_eq_real @ ( powr_real @ X @ A ) @ ( powr_real @ X @ B ) ) ) ) ).

% powr_mono
thf(fact_209_power__increasing,axiom,
    ! [N: nat,N5: nat,A: int] :
      ( ( ord_less_eq_nat @ N @ N5 )
     => ( ( ord_less_eq_int @ one_one_int @ A )
       => ( ord_less_eq_int @ ( power_power_int @ A @ N ) @ ( power_power_int @ A @ N5 ) ) ) ) ).

% power_increasing
thf(fact_210_power__increasing,axiom,
    ! [N: nat,N5: nat,A: nat] :
      ( ( ord_less_eq_nat @ N @ N5 )
     => ( ( ord_less_eq_nat @ one_one_nat @ A )
       => ( ord_less_eq_nat @ ( power_power_nat @ A @ N ) @ ( power_power_nat @ A @ N5 ) ) ) ) ).

% power_increasing
thf(fact_211_power__increasing,axiom,
    ! [N: nat,N5: nat,A: real] :
      ( ( ord_less_eq_nat @ N @ N5 )
     => ( ( ord_less_eq_real @ one_one_real @ A )
       => ( ord_less_eq_real @ ( power_power_real @ A @ N ) @ ( power_power_real @ A @ N5 ) ) ) ) ).

% power_increasing
thf(fact_212_one__power2,axiom,
    ( ( power_power_int @ one_one_int @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
    = one_one_int ) ).

% one_power2
thf(fact_213_one__power2,axiom,
    ( ( power_power_nat @ one_one_nat @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
    = one_one_nat ) ).

% one_power2
thf(fact_214_one__power2,axiom,
    ( ( power_power_real @ one_one_real @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
    = one_one_real ) ).

% one_power2
thf(fact_215_dbl__simps_I3_J,axiom,
    ( ( neg_numeral_dbl_int @ one_one_int )
    = ( numeral_numeral_int @ ( bit0 @ one ) ) ) ).

% dbl_simps(3)
thf(fact_216_dbl__simps_I3_J,axiom,
    ( ( neg_numeral_dbl_real @ one_one_real )
    = ( numeral_numeral_real @ ( bit0 @ one ) ) ) ).

% dbl_simps(3)
thf(fact_217_power__numeral,axiom,
    ! [K: num,L: num] :
      ( ( power_power_int @ ( numeral_numeral_int @ K ) @ ( numeral_numeral_nat @ L ) )
      = ( numeral_numeral_int @ ( pow @ K @ L ) ) ) ).

% power_numeral
thf(fact_218_power__numeral,axiom,
    ! [K: num,L: num] :
      ( ( power_power_real @ ( numeral_numeral_real @ K ) @ ( numeral_numeral_nat @ L ) )
      = ( numeral_numeral_real @ ( pow @ K @ L ) ) ) ).

% power_numeral
thf(fact_219_power__numeral,axiom,
    ! [K: num,L: num] :
      ( ( power_power_nat @ ( numeral_numeral_nat @ K ) @ ( numeral_numeral_nat @ L ) )
      = ( numeral_numeral_nat @ ( pow @ K @ L ) ) ) ).

% power_numeral
thf(fact_220_order__refl,axiom,
    ! [X: int] : ( ord_less_eq_int @ X @ X ) ).

% order_refl
thf(fact_221_order__refl,axiom,
    ! [X: nat] : ( ord_less_eq_nat @ X @ X ) ).

% order_refl
thf(fact_222_order__refl,axiom,
    ! [X: real] : ( ord_less_eq_real @ X @ X ) ).

% order_refl
thf(fact_223_order__refl,axiom,
    ! [X: num] : ( ord_less_eq_num @ X @ X ) ).

% order_refl
thf(fact_224_powr__numeral,axiom,
    ! [X: real,N: num] :
      ( ( ord_less_eq_real @ zero_zero_real @ X )
     => ( ( powr_real @ X @ ( numeral_numeral_real @ N ) )
        = ( power_power_real @ X @ ( numeral_numeral_nat @ N ) ) ) ) ).

% powr_numeral
thf(fact_225_power2__eq__iff__nonneg,axiom,
    ! [X: int,Y: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ X )
     => ( ( ord_less_eq_int @ zero_zero_int @ Y )
       => ( ( ( power_power_int @ X @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
            = ( power_power_int @ Y @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) )
          = ( X = Y ) ) ) ) ).

% power2_eq_iff_nonneg
thf(fact_226_power2__eq__iff__nonneg,axiom,
    ! [X: nat,Y: nat] :
      ( ( ord_less_eq_nat @ zero_zero_nat @ X )
     => ( ( ord_less_eq_nat @ zero_zero_nat @ Y )
       => ( ( ( power_power_nat @ X @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
            = ( power_power_nat @ Y @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) )
          = ( X = Y ) ) ) ) ).

% power2_eq_iff_nonneg
thf(fact_227_power2__eq__iff__nonneg,axiom,
    ! [X: real,Y: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ X )
     => ( ( ord_less_eq_real @ zero_zero_real @ Y )
       => ( ( ( power_power_real @ X @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
            = ( power_power_real @ Y @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) )
          = ( X = Y ) ) ) ) ).

% power2_eq_iff_nonneg
thf(fact_228_le0,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% le0
thf(fact_229_bot__nat__0_Oextremum,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ zero_zero_nat @ A ) ).

% bot_nat_0.extremum
thf(fact_230_d_I2_J,axiom,
    ord_less_int @ zero_zero_int @ d ).

% d(2)
thf(fact_231_le__zero__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_zero_eq
thf(fact_232_of__nat__0,axiom,
    ( ( semiri1382578993at_nat @ zero_zero_nat )
    = zero_zero_nat ) ).

% of_nat_0
thf(fact_233_of__nat__0,axiom,
    ( ( semiri2110766477t_real @ zero_zero_nat )
    = zero_zero_real ) ).

% of_nat_0
thf(fact_234_of__nat__0,axiom,
    ( ( semiri2019852685at_int @ zero_zero_nat )
    = zero_zero_int ) ).

% of_nat_0
thf(fact_235_of__nat__0__eq__iff,axiom,
    ! [N: nat] :
      ( ( zero_zero_nat
        = ( semiri1382578993at_nat @ N ) )
      = ( zero_zero_nat = N ) ) ).

% of_nat_0_eq_iff
thf(fact_236_of__nat__0__eq__iff,axiom,
    ! [N: nat] :
      ( ( zero_zero_real
        = ( semiri2110766477t_real @ N ) )
      = ( zero_zero_nat = N ) ) ).

% of_nat_0_eq_iff
thf(fact_237_of__nat__0__eq__iff,axiom,
    ! [N: nat] :
      ( ( zero_zero_int
        = ( semiri2019852685at_int @ N ) )
      = ( zero_zero_nat = N ) ) ).

% of_nat_0_eq_iff
thf(fact_238_of__nat__eq__0__iff,axiom,
    ! [M: nat] :
      ( ( ( semiri1382578993at_nat @ M )
        = zero_zero_nat )
      = ( M = zero_zero_nat ) ) ).

% of_nat_eq_0_iff
thf(fact_239_of__nat__eq__0__iff,axiom,
    ! [M: nat] :
      ( ( ( semiri2110766477t_real @ M )
        = zero_zero_real )
      = ( M = zero_zero_nat ) ) ).

% of_nat_eq_0_iff
thf(fact_240_of__nat__eq__0__iff,axiom,
    ! [M: nat] :
      ( ( ( semiri2019852685at_int @ M )
        = zero_zero_int )
      = ( M = zero_zero_nat ) ) ).

% of_nat_eq_0_iff
thf(fact_241_power__Suc0__right,axiom,
    ! [A: int] :
      ( ( power_power_int @ A @ ( suc @ zero_zero_nat ) )
      = A ) ).

% power_Suc0_right
thf(fact_242_power__Suc0__right,axiom,
    ! [A: nat] :
      ( ( power_power_nat @ A @ ( suc @ zero_zero_nat ) )
      = A ) ).

% power_Suc0_right
thf(fact_243_power__Suc0__right,axiom,
    ! [A: real] :
      ( ( power_power_real @ A @ ( suc @ zero_zero_nat ) )
      = A ) ).

% power_Suc0_right
thf(fact_244_of__int__0,axiom,
    ( ( ring_1_of_int_real @ zero_zero_int )
    = zero_zero_real ) ).

% of_int_0
thf(fact_245_of__int__0,axiom,
    ( ( ring_1_of_int_int @ zero_zero_int )
    = zero_zero_int ) ).

% of_int_0
thf(fact_246_of__int__0__eq__iff,axiom,
    ! [Z: int] :
      ( ( zero_zero_real
        = ( ring_1_of_int_real @ Z ) )
      = ( Z = zero_zero_int ) ) ).

% of_int_0_eq_iff
thf(fact_247_of__int__0__eq__iff,axiom,
    ! [Z: int] :
      ( ( zero_zero_int
        = ( ring_1_of_int_int @ Z ) )
      = ( Z = zero_zero_int ) ) ).

% of_int_0_eq_iff
thf(fact_248_of__int__eq__0__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_real @ Z )
        = zero_zero_real )
      = ( Z = zero_zero_int ) ) ).

% of_int_eq_0_iff
thf(fact_249_of__int__eq__0__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_int @ Z )
        = zero_zero_int )
      = ( Z = zero_zero_int ) ) ).

% of_int_eq_0_iff
thf(fact_250_powr__eq__0__iff,axiom,
    ! [W: real,Z: real] :
      ( ( ( powr_real @ W @ Z )
        = zero_zero_real )
      = ( W = zero_zero_real ) ) ).

% powr_eq_0_iff
thf(fact_251_powr__0,axiom,
    ! [Z: real] :
      ( ( powr_real @ zero_zero_real @ Z )
      = zero_zero_real ) ).

% powr_0
thf(fact_252_ceiling__zero,axiom,
    ( ( archim1371465213g_real @ zero_zero_real )
    = zero_zero_int ) ).

% ceiling_zero
thf(fact_253_nat__le__0,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ Z @ zero_zero_int )
     => ( ( nat2 @ Z )
        = zero_zero_nat ) ) ).

% nat_le_0
thf(fact_254_nat__0__iff,axiom,
    ! [I2: int] :
      ( ( ( nat2 @ I2 )
        = zero_zero_nat )
      = ( ord_less_eq_int @ I2 @ zero_zero_int ) ) ).

% nat_0_iff
thf(fact_255_power__Suc__0,axiom,
    ! [N: nat] :
      ( ( power_power_nat @ ( suc @ zero_zero_nat ) @ N )
      = ( suc @ zero_zero_nat ) ) ).

% power_Suc_0
thf(fact_256_nat__power__eq__Suc__0__iff,axiom,
    ! [X: nat,M: nat] :
      ( ( ( power_power_nat @ X @ M )
        = ( suc @ zero_zero_nat ) )
      = ( ( M = zero_zero_nat )
        | ( X
          = ( suc @ zero_zero_nat ) ) ) ) ).

% nat_power_eq_Suc_0_iff
thf(fact_257_nat__int,axiom,
    ! [N: nat] :
      ( ( nat2 @ ( semiri2019852685at_int @ N ) )
      = N ) ).

% nat_int
thf(fact_258_dbl__simps_I2_J,axiom,
    ( ( neg_numeral_dbl_real @ zero_zero_real )
    = zero_zero_real ) ).

% dbl_simps(2)
thf(fact_259_dbl__simps_I2_J,axiom,
    ( ( neg_numeral_dbl_int @ zero_zero_int )
    = zero_zero_int ) ).

% dbl_simps(2)
thf(fact_260_of__nat__le__0__iff,axiom,
    ! [M: nat] :
      ( ( ord_less_eq_int @ ( semiri2019852685at_int @ M ) @ zero_zero_int )
      = ( M = zero_zero_nat ) ) ).

% of_nat_le_0_iff
thf(fact_261_of__nat__le__0__iff,axiom,
    ! [M: nat] :
      ( ( ord_less_eq_nat @ ( semiri1382578993at_nat @ M ) @ zero_zero_nat )
      = ( M = zero_zero_nat ) ) ).

% of_nat_le_0_iff
thf(fact_262_of__nat__le__0__iff,axiom,
    ! [M: nat] :
      ( ( ord_less_eq_real @ ( semiri2110766477t_real @ M ) @ zero_zero_real )
      = ( M = zero_zero_nat ) ) ).

% of_nat_le_0_iff
thf(fact_263_power__0__Suc,axiom,
    ! [N: nat] :
      ( ( power_power_int @ zero_zero_int @ ( suc @ N ) )
      = zero_zero_int ) ).

% power_0_Suc
thf(fact_264_power__0__Suc,axiom,
    ! [N: nat] :
      ( ( power_power_nat @ zero_zero_nat @ ( suc @ N ) )
      = zero_zero_nat ) ).

% power_0_Suc
thf(fact_265_power__0__Suc,axiom,
    ! [N: nat] :
      ( ( power_power_real @ zero_zero_real @ ( suc @ N ) )
      = zero_zero_real ) ).

% power_0_Suc
thf(fact_266_power__zero__numeral,axiom,
    ! [K: num] :
      ( ( power_power_int @ zero_zero_int @ ( numeral_numeral_nat @ K ) )
      = zero_zero_int ) ).

% power_zero_numeral
thf(fact_267_power__zero__numeral,axiom,
    ! [K: num] :
      ( ( power_power_nat @ zero_zero_nat @ ( numeral_numeral_nat @ K ) )
      = zero_zero_nat ) ).

% power_zero_numeral
thf(fact_268_power__zero__numeral,axiom,
    ! [K: num] :
      ( ( power_power_real @ zero_zero_real @ ( numeral_numeral_nat @ K ) )
      = zero_zero_real ) ).

% power_zero_numeral
thf(fact_269_powr__zero__eq__one,axiom,
    ! [X: real] :
      ( ( ( X = zero_zero_real )
       => ( ( powr_real @ X @ zero_zero_real )
          = zero_zero_real ) )
      & ( ( X != zero_zero_real )
       => ( ( powr_real @ X @ zero_zero_real )
          = one_one_real ) ) ) ).

% powr_zero_eq_one
thf(fact_270_powr__nonneg__iff,axiom,
    ! [A: real,X: real] :
      ( ( ord_less_eq_real @ ( powr_real @ A @ X ) @ zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% powr_nonneg_iff
thf(fact_271_nat__1,axiom,
    ( ( nat2 @ one_one_int )
    = ( suc @ zero_zero_nat ) ) ).

% nat_1
thf(fact_272_int__eq__iff__numeral,axiom,
    ! [M: nat,V: num] :
      ( ( ( semiri2019852685at_int @ M )
        = ( numeral_numeral_int @ V ) )
      = ( M
        = ( numeral_numeral_nat @ V ) ) ) ).

% int_eq_iff_numeral
thf(fact_273_log__one,axiom,
    ! [A: real] :
      ( ( log @ A @ one_one_real )
      = zero_zero_real ) ).

% log_one
thf(fact_274_int__nat__eq,axiom,
    ! [Z: int] :
      ( ( ( ord_less_eq_int @ zero_zero_int @ Z )
       => ( ( semiri2019852685at_int @ ( nat2 @ Z ) )
          = Z ) )
      & ( ~ ( ord_less_eq_int @ zero_zero_int @ Z )
       => ( ( semiri2019852685at_int @ ( nat2 @ Z ) )
          = zero_zero_int ) ) ) ).

% int_nat_eq
thf(fact_275_dbl__simps_I5_J,axiom,
    ! [K: num] :
      ( ( neg_numeral_dbl_int @ ( numeral_numeral_int @ K ) )
      = ( numeral_numeral_int @ ( bit0 @ K ) ) ) ).

% dbl_simps(5)
thf(fact_276_dbl__simps_I5_J,axiom,
    ! [K: num] :
      ( ( neg_numeral_dbl_real @ ( numeral_numeral_real @ K ) )
      = ( numeral_numeral_real @ ( bit0 @ K ) ) ) ).

% dbl_simps(5)
thf(fact_277_of__int__0__le__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_eq_int @ zero_zero_int @ Z ) ) ).

% of_int_0_le_iff
thf(fact_278_of__int__0__le__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_real @ zero_zero_real @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_eq_int @ zero_zero_int @ Z ) ) ).

% of_int_0_le_iff
thf(fact_279_of__int__le__0__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ ( ring_1_of_int_int @ Z ) @ zero_zero_int )
      = ( ord_less_eq_int @ Z @ zero_zero_int ) ) ).

% of_int_le_0_iff
thf(fact_280_of__int__le__0__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_real @ ( ring_1_of_int_real @ Z ) @ zero_zero_real )
      = ( ord_less_eq_int @ Z @ zero_zero_int ) ) ).

% of_int_le_0_iff
thf(fact_281_ceiling__le__zero,axiom,
    ! [X: real] :
      ( ( ord_less_eq_int @ ( archim1371465213g_real @ X ) @ zero_zero_int )
      = ( ord_less_eq_real @ X @ zero_zero_real ) ) ).

% ceiling_le_zero
thf(fact_282_powr__one,axiom,
    ! [X: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ X )
     => ( ( powr_real @ X @ one_one_real )
        = X ) ) ).

% powr_one
thf(fact_283_powr__one__gt__zero__iff,axiom,
    ! [X: real] :
      ( ( ( powr_real @ X @ one_one_real )
        = X )
      = ( ord_less_eq_real @ zero_zero_real @ X ) ) ).

% powr_one_gt_zero_iff
thf(fact_284_of__nat__nat,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z )
     => ( ( semiri2110766477t_real @ ( nat2 @ Z ) )
        = ( ring_1_of_int_real @ Z ) ) ) ).

% of_nat_nat
thf(fact_285_of__nat__nat,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z )
     => ( ( semiri2019852685at_int @ ( nat2 @ Z ) )
        = ( ring_1_of_int_int @ Z ) ) ) ).

% of_nat_nat
thf(fact_286_zero__eq__power2,axiom,
    ! [A: int] :
      ( ( ( power_power_int @ A @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
        = zero_zero_int )
      = ( A = zero_zero_int ) ) ).

% zero_eq_power2
thf(fact_287_zero__eq__power2,axiom,
    ! [A: nat] :
      ( ( ( power_power_nat @ A @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
        = zero_zero_nat )
      = ( A = zero_zero_nat ) ) ).

% zero_eq_power2
thf(fact_288_zero__eq__power2,axiom,
    ! [A: real] :
      ( ( ( power_power_real @ A @ ( numeral_numeral_nat @ ( bit0 @ one ) ) )
        = zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% zero_eq_power2
thf(fact_289_power2__less__eq__zero__iff,axiom,
    ! [A: int] :
      ( ( ord_less_eq_int @ ( power_power_int @ A @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) @ zero_zero_int )
      = ( A = zero_zero_int ) ) ).

% power2_less_eq_zero_iff
thf(fact_290_power2__less__eq__zero__iff,axiom,
    ! [A: real] :
      ( ( ord_less_eq_real @ ( power_power_real @ A @ ( numeral_numeral_nat @ ( bit0 @ one ) ) ) @ zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% power2_less_eq_zero_iff
thf(fact_291_int__if,axiom,
    ! [P: $o,A: nat,B: nat] :
      ( ( P
       => ( ( semiri2019852685at_int @ ( if_nat @ P @ A @ B ) )
          = ( semiri2019852685at_int @ A ) ) )
      & ( ~ P
       => ( ( semiri2019852685at_int @ ( if_nat @ P @ A @ B ) )
          = ( semiri2019852685at_int @ B ) ) ) ) ).

% int_if
thf(fact_292_nat__int__comparison_I1_J,axiom,
    ( ( ^ [Y5: nat,Z4: nat] : ( Y5 = Z4 ) )
    = ( ^ [A3: nat,B2: nat] :
          ( ( semiri2019852685at_int @ A3 )
          = ( semiri2019852685at_int @ B2 ) ) ) ) ).

% nat_int_comparison(1)
thf(fact_293_int__ops_I1_J,axiom,
    ( ( semiri2019852685at_int @ zero_zero_nat )
    = zero_zero_int ) ).

% int_ops(1)
thf(fact_294_zero__le__imp__eq__int,axiom,
    ! [K: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ K )
     => ? [N3: nat] :
          ( K
          = ( semiri2019852685at_int @ N3 ) ) ) ).

% zero_le_imp_eq_int
thf(fact_295_nonneg__int__cases,axiom,
    ! [K: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ K )
     => ~ ! [N3: nat] :
            ( K
           != ( semiri2019852685at_int @ N3 ) ) ) ).

% nonneg_int_cases
thf(fact_296_int__int__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ( semiri2019852685at_int @ M )
        = ( semiri2019852685at_int @ N ) )
      = ( M = N ) ) ).

% int_int_eq
thf(fact_297_nat__eq__iff2,axiom,
    ! [M: nat,W: int] :
      ( ( M
        = ( nat2 @ W ) )
      = ( ( ( ord_less_eq_int @ zero_zero_int @ W )
         => ( W
            = ( semiri2019852685at_int @ M ) ) )
        & ( ~ ( ord_less_eq_int @ zero_zero_int @ W )
         => ( M = zero_zero_nat ) ) ) ) ).

% nat_eq_iff2
thf(fact_298_nat__eq__iff,axiom,
    ! [W: int,M: nat] :
      ( ( ( nat2 @ W )
        = M )
      = ( ( ( ord_less_eq_int @ zero_zero_int @ W )
         => ( W
            = ( semiri2019852685at_int @ M ) ) )
        & ( ~ ( ord_less_eq_int @ zero_zero_int @ W )
         => ( M = zero_zero_nat ) ) ) ) ).

% nat_eq_iff
thf(fact_299_zero__reorient,axiom,
    ! [X: real] :
      ( ( zero_zero_real = X )
      = ( X = zero_zero_real ) ) ).

% zero_reorient
thf(fact_300_zero__reorient,axiom,
    ! [X: nat] :
      ( ( zero_zero_nat = X )
      = ( X = zero_zero_nat ) ) ).

% zero_reorient
thf(fact_301_zero__reorient,axiom,
    ! [X: int] :
      ( ( zero_zero_int = X )
      = ( X = zero_zero_int ) ) ).

% zero_reorient
thf(fact_302_zero__le,axiom,
    ! [X: nat] : ( ord_less_eq_nat @ zero_zero_nat @ X ) ).

% zero_le
thf(fact_303_nat__zero__as__int,axiom,
    ( zero_zero_nat
    = ( nat2 @ zero_zero_int ) ) ).

% nat_zero_as_int
thf(fact_304_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N )
          = one_one_int ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N )
          = zero_zero_int ) ) ) ).

% power_0_left
thf(fact_305_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N )
          = one_one_nat ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N )
          = zero_zero_nat ) ) ) ).

% power_0_left
thf(fact_306_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N )
          = one_one_real ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N )
          = zero_zero_real ) ) ) ).

% power_0_left
thf(fact_307_nat__0__le,axiom,
    ! [Z: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z )
     => ( ( semiri2019852685at_int @ ( nat2 @ Z ) )
        = Z ) ) ).

% nat_0_le
thf(fact_308_int__eq__iff,axiom,
    ! [M: nat,Z: int] :
      ( ( ( semiri2019852685at_int @ M )
        = Z )
      = ( ( M
          = ( nat2 @ Z ) )
        & ( ord_less_eq_int @ zero_zero_int @ Z ) ) ) ).

% int_eq_iff
thf(fact_309_int__ops_I2_J,axiom,
    ( ( semiri2019852685at_int @ one_one_nat )
    = one_one_int ) ).

% int_ops(2)
thf(fact_310_le__numeral__extra_I3_J,axiom,
    ord_less_eq_int @ zero_zero_int @ zero_zero_int ).

% le_numeral_extra(3)
thf(fact_311_le__numeral__extra_I3_J,axiom,
    ord_less_eq_nat @ zero_zero_nat @ zero_zero_nat ).

% le_numeral_extra(3)
thf(fact_312_le__numeral__extra_I3_J,axiom,
    ord_less_eq_real @ zero_zero_real @ zero_zero_real ).

% le_numeral_extra(3)
thf(fact_313_zero__neq__numeral,axiom,
    ! [N: num] :
      ( zero_zero_int
     != ( numeral_numeral_int @ N ) ) ).

% zero_neq_numeral
thf(fact_314_zero__neq__numeral,axiom,
    ! [N: num] :
      ( zero_zero_real
     != ( numeral_numeral_real @ N ) ) ).

% zero_neq_numeral
thf(fact_315_zero__neq__numeral,axiom,
    ! [N: num] :
      ( zero_zero_nat
     != ( numeral_numeral_nat @ N ) ) ).

% zero_neq_numeral
thf(fact_316_power__not__zero,axiom,
    ! [A: int,N: nat] :
      ( ( A != zero_zero_int )
     => ( ( power_power_int @ A @ N )
       != zero_zero_int ) ) ).

% power_not_zero
thf(fact_317_power__not__zero,axiom,
    ! [A: nat,N: nat] :
      ( ( A != zero_zero_nat )
     => ( ( power_power_nat @ A @ N )
       != zero_zero_nat ) ) ).

% power_not_zero
thf(fact_318_power__not__zero,axiom,
    ! [A: real,N: nat] :
      ( ( A != zero_zero_real )
     => ( ( power_power_real @ A @ N )
       != zero_zero_real ) ) ).

% power_not_zero
thf(fact_319_exists__least__lemma,axiom,
    ! [P: nat > $o] :
      ( ~ ( P @ zero_zero_nat )
     => ( ? [X_1: nat] : ( P @ X_1 )
       => ? [N3: nat] :
            ( ~ ( P @ N3 )
            & ( P @ ( suc @ N3 ) ) ) ) ) ).

% exists_least_lemma
thf(fact_320_nat_Odistinct_I1_J,axiom,
    ! [X2: nat] :
      ( zero_zero_nat
     != ( suc @ X2 ) ) ).

% nat.distinct(1)
thf(fact_321_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat2: nat] :
      ( ( suc @ Nat2 )
     != zero_zero_nat ) ).

% old.nat.distinct(2)
thf(fact_322_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( zero_zero_nat
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_323_nat_OdiscI,axiom,
    ! [Nat: nat,X2: nat] :
      ( ( Nat
        = ( suc @ X2 ) )
     => ( Nat != zero_zero_nat ) ) ).

% nat.discI
thf(fact_324_nat__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ zero_zero_nat )
     => ( ! [N3: nat] :
            ( ( P @ N3 )
           => ( P @ ( suc @ N3 ) ) )
       => ( P @ N ) ) ) ).

% nat_induct
thf(fact_325_One__nat__def,axiom,
    ( one_one_nat
    = ( suc @ zero_zero_nat ) ) ).

% One_nat_def
thf(fact_326_diff__induct,axiom,
    ! [P: nat > nat > $o,M: nat,N: nat] :
      ( ! [X5: nat] : ( P @ X5 @ zero_zero_nat )
     => ( ! [Y3: nat] : ( P @ zero_zero_nat @ ( suc @ Y3 ) )
       => ( ! [X5: nat,Y3: nat] :
              ( ( P @ X5 @ Y3 )
             => ( P @ ( suc @ X5 ) @ ( suc @ Y3 ) ) )
         => ( P @ M @ N ) ) ) ) ).

% diff_induct
thf(fact_327_zero__induct,axiom,
    ! [P: nat > $o,K: nat] :
      ( ( P @ K )
     => ( ! [N3: nat] :
            ( ( P @ ( suc @ N3 ) )
           => ( P @ N3 ) )
       => ( P @ zero_zero_nat ) ) ) ).

% zero_induct
thf(fact_328_Suc__neq__Zero,axiom,
    ! [M: nat] :
      ( ( suc @ M )
     != zero_zero_nat ) ).

% Suc_neq_Zero
thf(fact_329_Zero__neq__Suc,axiom,
    ! [M: nat] :
      ( zero_zero_nat
     != ( suc @ M ) ) ).

% Zero_neq_Suc
thf(fact_330_Zero__not__Suc,axiom,
    ! [M: nat] :
      ( zero_zero_nat
     != ( suc @ M ) ) ).

% Zero_not_Suc
thf(fact_331_old_Onat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero_nat )
     => ~ ! [Nat3: nat] :
            ( Y
           != ( suc @ Nat3 ) ) ) ).

% old.nat.exhaust
thf(fact_332_old_Onat_Oinducts,axiom,
    ! [P: nat > $o,Nat: nat] :
      ( ( P @ zero_zero_nat )
     => ( ! [Nat3: nat] :
            ( ( P @ Nat3 )
           => ( P @ ( suc @ Nat3 ) ) )
       => ( P @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_333_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ? [M4: nat] :
          ( N
          = ( suc @ M4 ) ) ) ).

% not0_implies_Suc
thf(fact_334_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
     => ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_335_bot__nat__0_Oextremum__unique,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
      = ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_unique
thf(fact_336_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_0_eq
thf(fact_337_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% less_eq_nat.simps(1)
thf(fact_338_less__eq__int__code_I1_J,axiom,
    ord_less_eq_int @ zero_zero_int @ zero_zero_int ).

% less_eq_int_code(1)
thf(fact_339_le__nat__iff,axiom,
    ! [K: int,N: nat] :
      ( ( ord_less_eq_int @ zero_zero_int @ K )
     => ( ( ord_less_eq_nat @ N @ ( nat2 @ K ) )
        = ( ord_less_eq_int @ ( semiri2019852685at_int @ N ) @ K ) ) ) ).

% le_nat_iff
thf(fact_340_nat__int__comparison_I3_J,axiom,
    ( ord_less_eq_nat
    = ( ^ [A3: nat,B2: nat] : ( ord_less_eq_int @ ( semiri2019852685at_int @ A3 ) @ ( semiri2019852685at_int @ B2 ) ) ) ) ).

% nat_int_comparison(3)
thf(fact_341_zle__int,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_int @ ( semiri2019852685at_int @ M ) @ ( semiri2019852685at_int @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% zle_int
thf(fact_342_int__ops_I3_J,axiom,
    ! [N: num] :
      ( ( semiri2019852685at_int @ ( numeral_numeral_nat @ N ) )
      = ( numeral_numeral_int @ N ) ) ).

% int_ops(3)
thf(fact_343_ex__nat,axiom,
    ( ( ^ [P2: nat > $o] :
        ? [X6: nat] : ( P2 @ X6 ) )
    = ( ^ [P3: nat > $o] :
        ? [X3: int] :
          ( ( ord_less_eq_int @ zero_zero_int @ X3 )
          & ( P3 @ ( nat2 @ X3 ) ) ) ) ) ).

% ex_nat
thf(fact_344_all__nat,axiom,
    ( ( ^ [P2: nat > $o] :
        ! [X6: nat] : ( P2 @ X6 ) )
    = ( ^ [P3: nat > $o] :
        ! [X3: int] :
          ( ( ord_less_eq_int @ zero_zero_int @ X3 )
         => ( P3 @ ( nat2 @ X3 ) ) ) ) ) ).

% all_nat
thf(fact_345_eq__nat__nat__iff,axiom,
    ! [Z: int,Z5: int] :
      ( ( ord_less_eq_int @ zero_zero_int @ Z )
     => ( ( ord_less_eq_int @ zero_zero_int @ Z5 )
       => ( ( ( nat2 @ Z )
            = ( nat2 @ Z5 ) )
          = ( Z = Z5 ) ) ) ) ).

% eq_nat_nat_iff
thf(fact_346_powr__mono2,axiom,
    ! [A: real,X: real,Y: real] :
      ( ( ord_less_eq_real @ zero_zero_real @ A )
     => ( ( ord_less_eq_real @ zero_zero_real @ X )
       => ( ( ord_less_eq_real @ X @ Y )
         => ( ord_less_eq_real @ ( powr_real @ X @ A ) @ ( powr_real @ Y @ A ) ) ) ) ) ).

% powr_mono2
thf(fact_347_powr__ge__pzero,axiom,
    ! [X: real,Y: real] : ( ord_less_eq_real @ zero_zero_real @ ( powr_real @ X @ Y ) ) ).

% powr_ge_pzero
thf(fact_348_pow_Osimps_I1_J,axiom,
    ! [X: num] :
      ( ( pow @ X @ one )
      = X ) ).

% pow.simps(1)
thf(fact_349_nat__le__iff,axiom,
    ! [X: int,N: nat] :
      ( ( ord_less_eq_nat @ ( nat2 @ X ) @ N )
      = ( ord_less_eq_int @ X @ ( semiri2019852685at_int @ N ) ) ) ).

% nat_le_iff

% Helper facts (3)
thf(help_If_3_1_If_001t__Nat__Onat_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_If_001t__Nat__Onat_T,axiom,
    ! [X: nat,Y: nat] :
      ( ( if_nat @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_If_001t__Nat__Onat_T,axiom,
    ! [X: nat,Y: nat] :
      ( ( if_nat @ $true @ X @ Y )
      = X ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ord_less_eq_int @ d @ ( power_power_int @ ( numeral_numeral_int @ ( bit0 @ one ) ) @ ( nat2 @ ( archim1371465213g_real @ ( log @ ( numeral_numeral_real @ ( bit0 @ one ) ) @ ( ring_1_of_int_real @ d ) ) ) ) ) ).

%------------------------------------------------------------------------------
